IF EXISTS (SELECT * FROM SYS.tables WHERE NAME = 'CG_FND_VERBA_USO_PROD')
BEGIN
	GOTO FINAL
END

CREATE TABLE [dbo].[CG_FND_VERBA_USO_PROD](
	[CD_EMP] [int] NOT NULL,
	[CD_FND_VERBA_USO] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[VLR_IT] [money] NOT NULL,
	[LIMITE_VERBA] [money] NOT NULL,
	[DT_CAD] [datetime] NULL,
	[DT_ULT_ALT] [datetime] NULL,
	[CD_USU] [int] NOT NULL,
 CONSTRAINT [PK_CG_FND_VERBA_USO_PROD] PRIMARY KEY CLUSTERED 
(
	[CD_PROD] ASC,
	[CD_FND_VERBA_USO] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY]

FINAL:

GO


IF EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_CG_FND_VERBA_USO_PROD_CD_EMP')
BEGIN
	GOTO FINAL
END

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PROD_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PROD_CD_FND_VERBA_USO]  DEFAULT ((0)) FOR [CD_FND_VERBA_USO]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PROD_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PROD_VLR_IT]  DEFAULT ((0)) FOR [VLR_IT]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PROD_LIMITE_VERBA]  DEFAULT ((0)) FOR [LIMITE_VERBA]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PROD] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PROD_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PROD]  WITH NOCHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_USO_CG_FND_VERBA_USO_PROD] FOREIGN KEY([CD_FND_VERBA_USO], [CD_EMP])
REFERENCES [dbo].[CG_FND_VERBA_USO] ([CD_FND_VERBA_USO], [CD_EMP])
ON UPDATE CASCADE

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PROD] CHECK CONSTRAINT [FK_CG_FND_VERBA_USO_CG_FND_VERBA_USO_PROD]

FINAL: